/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupChartOfAccounts;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupChartOfAccounts
 * CorporateGroupChartOfAccounts}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.CorporateGroupChartOfAccountsField
 * CorporateGroupChartOfAccountsField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.CorporateGroupChartOfAccountsLink
 * CorporateGroupChartOfAccountsLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupChartOfAccounts#CORPORATE_GROUP_CHART_OF_ACCOUNTS_ID
 * CORPORATE_GROUP_CHART_OF_ACCOUNTS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupChartOfAccounts#CORPORATE_GROUP_CHART_OF_ACCOUNTS_TEXT
 * CORPORATE_GROUP_CHART_OF_ACCOUNTS_TEXT}</li>
 * </ul>
 *
 */
public interface CorporateGroupChartOfAccountsSelectable extends EntitySelectable<CorporateGroupChartOfAccounts>
{

}
