/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CostCenter;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CostCenter CostCenter}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.CostCenterField
 * CostCenterField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.CostCenterLink
 * CostCenterLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CostCenter#COST_CENTER_ID
 * COST_CENTER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CostCenter#COST_CENTER_TEXT
 * COST_CENTER_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CostCenter#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CostCenter#CONTROLLING_AREA_NAME
 * CONTROLLING_AREA_NAME}</li>
 * </ul>
 *
 */
public interface CostCenterSelectable extends EntitySelectable<CostCenter>
{

}
