/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CountryChartOfAccounts;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CountryChartOfAccounts
 * CountryChartOfAccounts}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.CountryChartOfAccountsField
 * CountryChartOfAccountsField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.CountryChartOfAccountsLink
 * CountryChartOfAccountsLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CountryChartOfAccounts#COUNTRY_CHART_OF_ACCOUNTS_ID
 * COUNTRY_CHART_OF_ACCOUNTS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CountryChartOfAccounts#COUNTRY_CHART_OF_ACCOUNTS_TEXT
 * COUNTRY_CHART_OF_ACCOUNTS_TEXT}</li>
 * </ul>
 *
 */
public interface CountryChartOfAccountsSelectable extends EntitySelectable<CountryChartOfAccounts>
{

}
