/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.DebitCreditCode;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.DebitCreditCode DebitCreditCode}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.DebitCreditCodeField
 * DebitCreditCodeField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.DebitCreditCodeLink
 * DebitCreditCodeLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.DebitCreditCode#DEBIT_CREDIT_CODE_ID
 * DEBIT_CREDIT_CODE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.DebitCreditCode#DEBIT_CREDIT_CODE_TEXT
 * DEBIT_CREDIT_CODE_TEXT}</li>
 * </ul>
 *
 */
public interface DebitCreditCodeSelectable extends EntitySelectable<DebitCreditCode>
{

}
