/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.EliminationProfitCenter;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.EliminationProfitCenter
 * EliminationProfitCenter}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.EliminationProfitCenterField
 * EliminationProfitCenterField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.EliminationProfitCenterLink
 * EliminationProfitCenterLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.EliminationProfitCenter#ELIMINATION_PROFIT_CENTER_ID
 * ELIMINATION_PROFIT_CENTER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.EliminationProfitCenter#ELIMINATION_PROFIT_CENTER_TEXT
 * ELIMINATION_PROFIT_CENTER_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.EliminationProfitCenter#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.EliminationProfitCenter#CONTROLLING_AREA_NAME
 * CONTROLLING_AREA_NAME}</li>
 * </ul>
 *
 */
public interface EliminationProfitCenterSelectable extends EntitySelectable<EliminationProfitCenter>
{

}
