/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialTransaction;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialTransaction FinancialTransaction}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.FinancialTransactionField
 * FinancialTransactionField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.FinancialTransactionLink
 * FinancialTransactionLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialTransaction#FINANCIAL_TRANSACTION_TYPE_ID
 * FINANCIAL_TRANSACTION_TYPE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialTransaction#FINANCIAL_TRANSACTION_TYPE_TEXT
 * FINANCIAL_TRANSACTION_TYPE_TEXT}</li>
 * </ul>
 *
 */
public interface FinancialTransactionSelectable extends EntitySelectable<FinancialTransaction>
{

}
