/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FiscalYearVariant;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FiscalYearVariant FiscalYearVariant}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.FiscalYearVariantField
 * FiscalYearVariantField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.FiscalYearVariantLink
 * FiscalYearVariantLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FiscalYearVariant#FISCAL_YEAR_VARIANT_ID
 * FISCAL_YEAR_VARIANT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FiscalYearVariant#FISCAL_YEAR_VARIANT_TEXT
 * FISCAL_YEAR_VARIANT_TEXT}</li>
 * </ul>
 *
 */
public interface FiscalYearVariantSelectable extends EntitySelectable<FiscalYearVariant>
{

}
