/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency1;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency1 FreeDefinedCurrency1}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.FreeDefinedCurrency1Field
 * FreeDefinedCurrency1Field} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.FreeDefinedCurrency1Link
 * FreeDefinedCurrency1Link}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency1#FREE_DEFINED_CURRENCY1_I_D
 * FREE_DEFINED_CURRENCY1_I_D}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency1#FREE_DEFINED_CURRENCY1_TEXT
 * FREE_DEFINED_CURRENCY1_TEXT}</li>
 * </ul>
 *
 */
public interface FreeDefinedCurrency1Selectable extends EntitySelectable<FreeDefinedCurrency1>
{

}
