/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency3;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency3 FreeDefinedCurrency3}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.FreeDefinedCurrency3Field
 * FreeDefinedCurrency3Field} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.FreeDefinedCurrency3Link
 * FreeDefinedCurrency3Link}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency3#FREE_DEFINED_CURRENCY3_I_D
 * FREE_DEFINED_CURRENCY3_I_D}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency3#FREE_DEFINED_CURRENCY3_TEXT
 * FREE_DEFINED_CURRENCY3_TEXT}</li>
 * </ul>
 *
 */
public interface FreeDefinedCurrency3Selectable extends EntitySelectable<FreeDefinedCurrency3>
{

}
