/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency4;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency4 FreeDefinedCurrency4}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.FreeDefinedCurrency4Field
 * FreeDefinedCurrency4Field} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.FreeDefinedCurrency4Link
 * FreeDefinedCurrency4Link}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency4#FREE_DEFINED_CURRENCY4_I_D
 * FREE_DEFINED_CURRENCY4_I_D}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency4#FREE_DEFINED_CURRENCY4_TEXT
 * FREE_DEFINED_CURRENCY4_TEXT}</li>
 * </ul>
 *
 */
public interface FreeDefinedCurrency4Selectable extends EntitySelectable<FreeDefinedCurrency4>
{

}
