/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency5;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency5 FreeDefinedCurrency5}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.FreeDefinedCurrency5Field
 * FreeDefinedCurrency5Field} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.FreeDefinedCurrency5Link
 * FreeDefinedCurrency5Link}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency5#FREE_DEFINED_CURRENCY5_I_D
 * FREE_DEFINED_CURRENCY5_I_D}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency5#FREE_DEFINED_CURRENCY5_TEXT
 * FREE_DEFINED_CURRENCY5_TEXT}</li>
 * </ul>
 *
 */
public interface FreeDefinedCurrency5Selectable extends EntitySelectable<FreeDefinedCurrency5>
{

}
