/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency8;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency8 FreeDefinedCurrency8}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.FreeDefinedCurrency8Field
 * FreeDefinedCurrency8Field} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.FreeDefinedCurrency8Link
 * FreeDefinedCurrency8Link}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency8#FREE_DEFINED_CURRENCY8_I_D
 * FREE_DEFINED_CURRENCY8_I_D}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency8#FREE_DEFINED_CURRENCY8_TEXT
 * FREE_DEFINED_CURRENCY8_TEXT}</li>
 * </ul>
 *
 */
public interface FreeDefinedCurrency8Selectable extends EntitySelectable<FreeDefinedCurrency8>
{

}
