/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FunctionalArea;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FunctionalArea FunctionalArea}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.FunctionalAreaField
 * FunctionalAreaField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.FunctionalAreaLink FunctionalAreaLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FunctionalArea#FUNCTIONAL_AREA_ID
 * FUNCTIONAL_AREA_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FunctionalArea#FUNCTIONAL_AREA_TEXT
 * FUNCTIONAL_AREA_TEXT}</li>
 * </ul>
 *
 */
public interface FunctionalAreaSelectable extends EntitySelectable<FunctionalArea>
{

}
