/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccountHierarchy;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccountHierarchy GLAccountHierarchy}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.GLAccountHierarchyField
 * GLAccountHierarchyField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.GLAccountHierarchyLink
 * GLAccountHierarchyLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccountHierarchy#GL_ACCOUNT_HIERARCHY_ID
 * GL_ACCOUNT_HIERARCHY_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccountHierarchy#GL_ACCOUNT_HIERARCHY_TEXT
 * GL_ACCOUNT_HIERARCHY_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccountHierarchy#CHART_OF_ACCOUNTS
 * CHART_OF_ACCOUNTS}</li>
 * </ul>
 *
 */
public interface GLAccountHierarchySelectable extends EntitySelectable<GLAccountHierarchy>
{

}
