/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccount;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccount GLAccount}. This interface is used
 * by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.GLAccountField GLAccountField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.GLAccountLink GLAccountLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccount#GL_ACCOUNT GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccount#GL_ACCOUNT_TEXT
 * GL_ACCOUNT_TEXT}</li>
 * </ul>
 *
 */
public interface GLAccountSelectable extends EntitySelectable<GLAccount>
{

}
