/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccount_2;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccount_2 GLAccount_2}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.GLAccount_2Field
 * GLAccount_2Field} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.GLAccount_2Link
 * GLAccount_2Link}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccount_2#GL_ACCOUNT_TYPE_ID
 * GL_ACCOUNT_TYPE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccount_2#GL_ACCOUNT_TYPE_TEXT
 * GL_ACCOUNT_TYPE_TEXT}</li>
 * </ul>
 *
 */
public interface GLAccount_2Selectable extends EntitySelectable<GLAccount_2>
{

}
