/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GlobalCurrency;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GlobalCurrency GlobalCurrency}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.GlobalCurrencyField
 * GlobalCurrencyField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.GlobalCurrencyLink GlobalCurrencyLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GlobalCurrency#GLOBAL_CURRENCY_ID
 * GLOBAL_CURRENCY_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GlobalCurrency#GLOBAL_CURRENCY_TEXT
 * GLOBAL_CURRENCY_TEXT}</li>
 * </ul>
 *
 */
public interface GlobalCurrencySelectable extends EntitySelectable<GlobalCurrency>
{

}
