/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GroupMasterFixedAsset;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GroupMasterFixedAsset GroupMasterFixedAsset}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.GroupMasterFixedAssetField
 * GroupMasterFixedAssetField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.GroupMasterFixedAssetLink
 * GroupMasterFixedAssetLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GroupMasterFixedAsset#GROUP_MASTER_FIXED_ASSET_ID
 * GROUP_MASTER_FIXED_ASSET_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GroupMasterFixedAsset#GROUP_MASTER_FIXED_ASSET_TEXT
 * GROUP_MASTER_FIXED_ASSET_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GroupMasterFixedAsset#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GroupMasterFixedAsset#COMPANY_CODE_NAME
 * COMPANY_CODE_NAME}</li>
 * </ul>
 *
 */
public interface GroupMasterFixedAssetSelectable extends EntitySelectable<GroupMasterFixedAsset>
{

}
