/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStkSalesDocItm;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStkSalesDocItm
 * InventorySpclStkSalesDocItm}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.InventorySpclStkSalesDocItmField
 * InventorySpclStkSalesDocItmField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.InventorySpclStkSalesDocItmLink
 * InventorySpclStkSalesDocItmLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStkSalesDocItm#INVENTORY_SPCL_STK_SALES_DOC_ITM_ID
 * INVENTORY_SPCL_STK_SALES_DOC_ITM_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStkSalesDocItm#INVENTORY_SPCL_STK_SALES_DOC_ITM_TEXT
 * INVENTORY_SPCL_STK_SALES_DOC_ITM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStkSalesDocItm#INVENTORY_SPCL_STK_SALES_DOCUMENT
 * INVENTORY_SPCL_STK_SALES_DOCUMENT}</li>
 * </ul>
 *
 */
public interface InventorySpclStkSalesDocItmSelectable extends EntitySelectable<InventorySpclStkSalesDocItm>
{

}
