/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStkSalesDocument;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStkSalesDocument
 * InventorySpclStkSalesDocument}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.InventorySpclStkSalesDocumentField
 * InventorySpclStkSalesDocumentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.InventorySpclStkSalesDocumentLink
 * InventorySpclStkSalesDocumentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStkSalesDocument#INVENTORY_SPCL_STK_SALES_DOCUMENT_ID
 * INVENTORY_SPCL_STK_SALES_DOCUMENT_ID}</li>
 * </ul>
 *
 */
public interface InventorySpclStkSalesDocumentSelectable extends EntitySelectable<InventorySpclStkSalesDocument>
{

}
