/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStockWBSElement;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStockWBSElement
 * InventorySpclStockWBSElement}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.InventorySpclStockWBSElementField
 * InventorySpclStockWBSElementField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.InventorySpclStockWBSElementLink
 * InventorySpclStockWBSElementLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStockWBSElement#INVENTORY_SPCL_STOCK_WBS_ELEMENT_ID
 * INVENTORY_SPCL_STOCK_WBS_ELEMENT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStockWBSElement#INVENTORY_SPCL_STOCK_WBS_ELEMENT_TEXT
 * INVENTORY_SPCL_STOCK_WBS_ELEMENT_TEXT}</li>
 * </ul>
 *
 */
public interface InventorySpclStockWBSElementSelectable extends EntitySelectable<InventorySpclStockWBSElement>
{

}
