/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStock;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStock InventorySpecialStock}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.InventorySpecialStockField
 * InventorySpecialStockField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.InventorySpecialStockLink
 * InventorySpecialStockLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStock#INVENTORY_SPECIAL_STOCK_TYPE_ID
 * INVENTORY_SPECIAL_STOCK_TYPE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStock#INVENTORY_SPECIAL_STOCK_TYPE_TEXT
 * INVENTORY_SPECIAL_STOCK_TYPE_TEXT}</li>
 * </ul>
 *
 */
public interface InventorySpecialStockSelectable extends EntitySelectable<InventorySpecialStock>
{

}
