/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockSupplier;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockSupplier
 * InventorySpecialStockSupplier}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.InventorySpecialStockSupplierField
 * InventorySpecialStockSupplierField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.InventorySpecialStockSupplierLink
 * InventorySpecialStockSupplierLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockSupplier#INVENTORY_SPECIAL_STOCK_SUPPLIER_ID
 * INVENTORY_SPECIAL_STOCK_SUPPLIER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockSupplier#INVENTORY_SPECIAL_STOCK_SUPPLIER_TEXT
 * INVENTORY_SPECIAL_STOCK_SUPPLIER_TEXT}</li>
 * </ul>
 *
 */
public interface InventorySpecialStockSupplierSelectable extends EntitySelectable<InventorySpecialStockSupplier>
{

}
