/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockValn;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockValn
 * InventorySpecialStockValn}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.InventorySpecialStockValnField
 * InventorySpecialStockValnField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.InventorySpecialStockValnLink
 * InventorySpecialStockValnLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockValn#INVENTORY_SPECIAL_STOCK_VALN_TYPE_ID
 * INVENTORY_SPECIAL_STOCK_VALN_TYPE_ID}</li>
 * </ul>
 *
 */
public interface InventorySpecialStockValnSelectable extends EntitySelectable<InventorySpecialStockValn>
{

}
