/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpclStockWBSElmntExtID;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpclStockWBSElmntExtID
 * InvtrySpclStockWBSElmntExtID}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.InvtrySpclStockWBSElmntExtIDField
 * InvtrySpclStockWBSElmntExtIDField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.InvtrySpclStockWBSElmntExtIDLink
 * InvtrySpclStockWBSElmntExtIDLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpclStockWBSElmntExtID#INVTRY_SPCL_STOCK_WBS_ELMNT_EXT_IDID
 * INVTRY_SPCL_STOCK_WBS_ELMNT_EXT_IDID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpclStockWBSElmntExtID#INVTRY_SPCL_STOCK_WBS_ELMNT_EXT_ID_TEXT
 * INVTRY_SPCL_STOCK_WBS_ELMNT_EXT_ID_TEXT}</li>
 * </ul>
 *
 */
public interface InvtrySpclStockWBSElmntExtIDSelectable extends EntitySelectable<InvtrySpclStockWBSElmntExtID>
{

}
