/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpclStockWBSElmntIntID;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpclStockWBSElmntIntID
 * InvtrySpclStockWBSElmntIntID}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.InvtrySpclStockWBSElmntIntIDField
 * InvtrySpclStockWBSElmntIntIDField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.InvtrySpclStockWBSElmntIntIDLink
 * InvtrySpclStockWBSElmntIntIDLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpclStockWBSElmntIntID#INVTRY_SPCL_STOCK_WBS_ELMNT_INT_IDID
 * INVTRY_SPCL_STOCK_WBS_ELMNT_INT_IDID}</li>
 * </ul>
 *
 */
public interface InvtrySpclStockWBSElmntIntIDSelectable extends EntitySelectable<InvtrySpclStockWBSElmntIntID>
{

}
