/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpecialStockValnType_2;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpecialStockValnType_2
 * InvtrySpecialStockValnType_2}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.InvtrySpecialStockValnType_2Field
 * InvtrySpecialStockValnType_2Field} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.InvtrySpecialStockValnType_2Link
 * InvtrySpecialStockValnType_2Link}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpecialStockValnType_2#INVTRY_SPECIAL_STOCK_VALN_TYPE_2_I_D
 * INVTRY_SPECIAL_STOCK_VALN_TYPE_2_I_D}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpecialStockValnType_2#INVTRY_SPECIAL_STOCK_VALN_TYPE_2_TEXT
 * INVTRY_SPECIAL_STOCK_VALN_TYPE_2_TEXT}</li>
 * </ul>
 *
 */
public interface InvtrySpecialStockValnType_2Selectable extends EntitySelectable<InvtrySpecialStockValnType_2>
{

}
