/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsBalanceSheetAccount;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsBalanceSheetAccount IsBalanceSheetAccount}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.IsBalanceSheetAccountField
 * IsBalanceSheetAccountField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.IsBalanceSheetAccountLink
 * IsBalanceSheetAccountLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsBalanceSheetAccount#IS_BALANCE_SHEET_ACCOUNT_ID
 * IS_BALANCE_SHEET_ACCOUNT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsBalanceSheetAccount#IS_BALANCE_SHEET_ACCOUNT_TEXT
 * IS_BALANCE_SHEET_ACCOUNT_TEXT}</li>
 * </ul>
 *
 */
public interface IsBalanceSheetAccountSelectable extends EntitySelectable<IsBalanceSheetAccount>
{

}
