/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsOpenItemManaged;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsOpenItemManaged IsOpenItemManaged}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.IsOpenItemManagedField
 * IsOpenItemManagedField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.IsOpenItemManagedLink
 * IsOpenItemManagedLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsOpenItemManaged#IS_OPEN_ITEM_MANAGED_ID
 * IS_OPEN_ITEM_MANAGED_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsOpenItemManaged#IS_OPEN_ITEM_MANAGED_TEXT
 * IS_OPEN_ITEM_MANAGED_TEXT}</li>
 * </ul>
 *
 */
public interface IsOpenItemManagedSelectable extends EntitySelectable<IsOpenItemManaged>
{

}
