/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsReversal;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsReversal IsReversal}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.IsReversalField
 * IsReversalField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.IsReversalLink
 * IsReversalLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsReversal#IS_REVERSAL_ID
 * IS_REVERSAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsReversal#IS_REVERSAL_TEXT
 * IS_REVERSAL_TEXT}</li>
 * </ul>
 *
 */
public interface IsReversalSelectable extends EntitySelectable<IsReversal>
{

}
