/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LineItemIsCompleted;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LineItemIsCompleted LineItemIsCompleted}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.LineItemIsCompletedField
 * LineItemIsCompletedField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.LineItemIsCompletedLink
 * LineItemIsCompletedLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LineItemIsCompleted#LINE_ITEM_IS_COMPLETED_ID
 * LINE_ITEM_IS_COMPLETED_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LineItemIsCompleted#LINE_ITEM_IS_COMPLETED_TEXT
 * LINE_ITEM_IS_COMPLETED_TEXT}</li>
 * </ul>
 *
 */
public interface LineItemIsCompletedSelectable extends EntitySelectable<LineItemIsCompleted>
{

}
