/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LogicalSystem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LogicalSystem LogicalSystem}. This interface
 * is used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.LogicalSystemField
 * LogicalSystemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.LogicalSystemLink LogicalSystemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LogicalSystem#LOGICAL_SYSTEM_ID
 * LOGICAL_SYSTEM_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LogicalSystem#LOGICAL_SYSTEM_TEXT
 * LOGICAL_SYSTEM_TEXT}</li>
 * </ul>
 *
 */
public interface LogicalSystemSelectable extends EntitySelectable<LogicalSystem>
{

}
