/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult MaterialGroupResult}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.MaterialGroupResultField
 * MaterialGroupResultField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.MaterialGroupResultLink
 * MaterialGroupResultLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#COMPANY_CODE_NAME
 * COMPANY_CODE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#GL_ACCOUNT
 * GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#GL_ACCOUNT_HIERARCHY_NAME
 * GL_ACCOUNT_HIERARCHY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#BUSINESS_PROCESS
 * BUSINESS_PROCESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#FREE_DEFINED_CURRENCY8
 * FREE_DEFINED_CURRENCY8}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_COST_OBJECT
 * PARTNER_COST_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#ASSET_VALUE_DATE
 * ASSET_VALUE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#ASSET_VALUE_DATE_T
 * ASSET_VALUE_DATE_T}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#FISCAL_YEAR_PERIOD
 * FISCAL_YEAR_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#QUANTITY_IS_INCOMPLETE
 * QUANTITY_IS_INCOMPLETE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#IS_OPEN_ITEM_MANAGED
 * IS_OPEN_ITEM_MANAGED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#CORPORATE_GROUP_ACCOUNT
 * CORPORATE_GROUP_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#CORPORATE_GROUP_ACCOUNT_T
 * CORPORATE_GROUP_ACCOUNT_T}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#BILLING_DOCUMENT_TYPE
 * BILLING_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#FISCAL_QUARTER
 * FISCAL_QUARTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#CORPORATE_GROUP_CHART_OF_ACCOUNTS
 * CORPORATE_GROUP_CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#CLEARING_DOC_FISCAL_YEAR
 * CLEARING_DOC_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_WBS_ELEMENT
 * PARTNER_WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#FREE_DEFINED_CURRENCY2
 * FREE_DEFINED_CURRENCY2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_PROFIT_CENTER
 * PARTNER_PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_PROFIT_CENTER_NAME
 * PARTNER_PROFIT_CENTER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_CONTROLLING_OBJECT_CLASS
 * PARTNER_CONTROLLING_OBJECT_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#GL_ACCOUNT_TYPE
 * GL_ACCOUNT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#ACCOUNTING_DOCUMENT_CATEGORY
 * ACCOUNTING_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#BUSINESS_TRANSACTION_TYPE
 * BUSINESS_TRANSACTION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#CALENDAR_MONTH
 * CALENDAR_MONTH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#CALENDAR_QUARTER
 * CALENDAR_QUARTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#CLEARING_ACCOUNTING_DOCUMENT
 * CLEARING_ACCOUNTING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#ACCOUNTING_DOCUMENT_TYPE
 * ACCOUNTING_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#ACCOUNTING_DOCUMENT_TYPE_NAME
 * ACCOUNTING_DOCUMENT_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#FINANCIAL_ACCOUNT_TYPE
 * FINANCIAL_ACCOUNT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#FINANCIAL_ACCOUNT_TYPE_NAME
 * FINANCIAL_ACCOUNT_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#BUSINESS_AREA_NAME
 * BUSINESS_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#ORIGIN_COST_CTR_ACTIVITY_TYPE
 * ORIGIN_COST_CTR_ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#CHART_OF_ACCOUNTS
 * CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#CONTROLLING_AREA_NAME
 * CONTROLLING_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#CONTROLLING_OBJECT_CLASS
 * CONTROLLING_OBJECT_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_COST_CENTER
 * PARTNER_COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#SENDER_COST_CENTER_NAME
 * SENDER_COST_CENTER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#DEBIT_CREDIT_CODE
 * DEBIT_CREDIT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#DEBIT_CREDIT_CODE_NAME
 * DEBIT_CREDIT_CODE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#POSTING_DATE
 * POSTING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#POSTING_DATE_T
 * POSTING_DATE_T}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#FISCAL_YEAR_VARIANT
 * FISCAL_YEAR_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#FUNCTIONAL_AREA
 * FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#FUNCTIONAL_AREA_NAME
 * FUNCTIONAL_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#BUDGET_PERIOD
 * BUDGET_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#CALENDAR_WEEK
 * CALENDAR_WEEK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#CALENDAR_YEAR
 * CALENDAR_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#CLEARING_DATE
 * CLEARING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#CLEARING_DATE_T
 * CLEARING_DATE_T}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#COST_CENTER_NAME
 * COST_CENTER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#COST_OBJECT
 * COST_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#FISCAL_PERIOD
 * FISCAL_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#FISCAL_WEEK
 * FISCAL_WEEK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#FUND FUND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#GRANT_ID
 * GRANT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#IS_REVERSAL
 * IS_REVERSAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#IS_REVERSED
 * IS_REVERSED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#IS_SETTLED
 * IS_SETTLED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#IS_SETTLEMENT
 * IS_SETTLEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#JOINT_VENTURE
 * JOINT_VENTURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#ORDER_ID
 * ORDER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_FUND
 * PARTNER_FUND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_GRANT
 * PARTNER_GRANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_ORDER
 * PARTNER_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#SOLD_MATERIAL
 * SOLD_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#SOLD_PRODUCT
 * SOLD_PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#TAX_CODE
 * TAX_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#WBS_ELEMENT
 * WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#HOUSE_BANK
 * HOUSE_BANK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#INVENTORY_SPECIAL_STOCK_VALN_TYPE
 * INVENTORY_SPECIAL_STOCK_VALN_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#LEDGER LEDGER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#MASTER_FIXED_ASSET
 * MASTER_FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#POSTING_KEY
 * POSTING_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#POSTING_KEY_NAME
 * POSTING_KEY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PROFIT_CENTER_NAME
 * PROFIT_CENTER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#SEGMENT SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#SEGMENT_NAME
 * SEGMENT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#SPECIAL_GL_CODE
 * SPECIAL_GL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#FINANCIAL_TRANSACTION_TYPE
 * FINANCIAL_TRANSACTION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#FIXED_ASSET
 * FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#JOINT_VENTURE_EQUITY_TYPE
 * JOINT_VENTURE_EQUITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#HOUSE_BANK_ACCOUNT
 * HOUSE_BANK_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#INVENTORY_SPECIAL_STOCK_TYPE
 * INVENTORY_SPECIAL_STOCK_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#ALTERNATIVE_GL_ACCOUNT
 * ALTERNATIVE_GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#ALTERNATIVE_GL_ACCOUNT_T
 * ALTERNATIVE_GL_ACCOUNT_T}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PLANT_NAME
 * PLANT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#ORDER_CATEGORY
 * ORDER_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PRODUCT PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#MATERIAL_NAME
 * MATERIAL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PRODUCT_GROUP
 * PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PROJECT PROJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#VALUATION_AREA
 * VALUATION_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#CUSTOMER_GROUP
 * CUSTOMER_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#CUSTOMER_GROUP_NAME
 * CUSTOMER_GROUP_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#INVENTORY_SPCL_STK_SALES_DOCUMENT
 * INVENTORY_SPCL_STK_SALES_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#INVENTORY_SPCL_STK_SALES_DOC_ITM
 * INVENTORY_SPCL_STK_SALES_DOC_ITM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#INVTRY_SPCL_STOCK_WBS_ELMNT_INT_ID
 * INVTRY_SPCL_STOCK_WBS_ELMNT_INT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#INVENTORY_SPCL_STOCK_WBS_ELEMENT
 * INVENTORY_SPCL_STOCK_WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#CALENDAR_YEAR_MONTH
 * CALENDAR_YEAR_MONTH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#CUSTOMER_NAME
 * CUSTOMER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#SUPPLIER_NAME
 * SUPPLIER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#BALANCE_TRANSACTION_CURRENCY
 * BALANCE_TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#ASSIGNMENT_REFERENCE
 * ASSIGNMENT_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#WBS_ELEMENT_EXTERNAL_ID
 * WBS_ELEMENT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#ORGANIZATION_DIVISION
 * ORGANIZATION_DIVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_PROJECT_NETWORK_ACTIVITY
 * PARTNER_PROJECT_NETWORK_ACTIVITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#CALENDAR_YEAR_QUARTER
 * CALENDAR_YEAR_QUARTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#IS_BALANCE_SHEET_ACCOUNT
 * IS_BALANCE_SHEET_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_ACCOUNT_ASSIGNMENT_TYPE
 * PARTNER_ACCOUNT_ASSIGNMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#FISCAL_YEAR_WEEK
 * FISCAL_YEAR_WEEK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#JOINT_VENTURE_EQUITY_GROUP
 * JOINT_VENTURE_EQUITY_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#FINANCIAL_MANAGEMENT_AREA
 * FINANCIAL_MANAGEMENT_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#COST_CTR_ACTIVITY_TYPE
 * COST_CTR_ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#SENDER_ACCOUNT_ASSIGNMENT
 * SENDER_ACCOUNT_ASSIGNMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#FISCAL_YEAR_QUARTER
 * FISCAL_YEAR_QUARTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#REFERENCE_DOCUMENT_TYPE
 * REFERENCE_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#GROUP_FIXED_ASSET
 * GROUP_FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#REFERENCE_DOCUMENT_ITEM_GROUP
 * REFERENCE_DOCUMENT_ITEM_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#ASSET_DEPRECIATION_AREA
 * ASSET_DEPRECIATION_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_SEGMENT
 * PARTNER_SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_SEGMENT_NAME
 * PARTNER_SEGMENT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#CLEARING_JOURNAL_ENTRY
 * CLEARING_JOURNAL_ENTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#OPERATING_CONCERN
 * OPERATING_CONCERN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#INVTRY_SPCL_STOCK_WBS_ELMNT_EXT_ID
 * INVTRY_SPCL_STOCK_WBS_ELMNT_EXT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#FISCAL_PERIOD_END_DATE
 * FISCAL_PERIOD_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#FISCAL_PERIOD_END_DATE_T
 * FISCAL_PERIOD_END_DATE_T}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#COUNTRY_CHART_OF_ACCOUNTS
 * COUNTRY_CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#FISCAL_PERIOD_START_DATE
 * FISCAL_PERIOD_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#FISCAL_PERIOD_START_DATE_T
 * FISCAL_PERIOD_START_DATE_T}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#FREE_DEFINED_CURRENCY6
 * FREE_DEFINED_CURRENCY6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#ACCOUNT_ASSIGNMENT
 * ACCOUNT_ASSIGNMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_COST_CTR_ACTIVITY_TYPE
 * PARTNER_COST_CTR_ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_BUSINESS_PROCESS
 * PARTNER_BUSINESS_PROCESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#RELATED_NETWORK_ACTIVITY
 * RELATED_NETWORK_ACTIVITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#SALES_DOCUMENT
 * SALES_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#FREE_DEFINED_CURRENCY1
 * FREE_DEFINED_CURRENCY1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#FISCAL_PERIOD_DATE
 * FISCAL_PERIOD_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#FREE_DEFINED_CURRENCY3
 * FREE_DEFINED_CURRENCY3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#ASSET_TRANSACTION_TYPE
 * ASSET_TRANSACTION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PURCHASING_DOCUMENT
 * PURCHASING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#INVTRY_SPECIAL_STOCK_VALN_TYPE_2
 * INVTRY_SPECIAL_STOCK_VALN_TYPE_2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#ELIMINATION_PROFIT_CENTER
 * ELIMINATION_PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#ELIMINATION_PROFIT_CENTER_NAME
 * ELIMINATION_PROFIT_CENTER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#GLOBAL_CURRENCY
 * GLOBAL_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PREDECESSOR_REFERENCE_DOC_TYPE
 * PREDECESSOR_REFERENCE_DOC_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#LEDGER_FISCAL_YEAR
 * LEDGER_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_SALES_DOCUMENT
 * PARTNER_SALES_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_ACCOUNT_ASSIGNMENT
 * PARTNER_ACCOUNT_ASSIGNMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#OFFSETTING_ACCOUNT
 * OFFSETTING_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_BUDGET_PERIOD
 * PARTNER_BUDGET_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#ACCOUNTING_DOC_CREATED_BY_USER
 * ACCOUNTING_DOC_CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#FREE_DEFINED_CURRENCY4
 * FREE_DEFINED_CURRENCY4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PROJECT_NETWORK
 * PROJECT_NETWORK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#LINE_ITEM_IS_COMPLETED
 * LINE_ITEM_IS_COMPLETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_PROJECT_INTERNAL_ID
 * PARTNER_PROJECT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#JOINT_VENTURE_COST_RECOVERY_CODE
 * JOINT_VENTURE_COST_RECOVERY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#INVENTORY_SPECIAL_STOCK_SUPPLIER
 * INVENTORY_SPECIAL_STOCK_SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#INVTRY_SPECIAL_STOCK_SUPPLIER_NAME
 * INVTRY_SPECIAL_STOCK_SUPPLIER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#ACCOUNT_ASSIGNMENT_TYPE
 * ACCOUNT_ASSIGNMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#SOLD_PRODUCT_GROUP
 * SOLD_PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#MATERIAL_GROUP_NAME
 * MATERIAL_GROUP_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_PROJECT
 * PARTNER_PROJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#CLEARING_JOURNAL_ENTRY_FISCAL_YEAR
 * CLEARING_JOURNAL_ENTRY_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_COMPANY
 * PARTNER_COMPANY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#LOGICAL_SYSTEM
 * LOGICAL_SYSTEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PERSONNEL_NUMBER
 * PERSONNEL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#GROUP_MASTER_FIXED_ASSET
 * GROUP_MASTER_FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#SALES_DOCUMENT_ITEM
 * SALES_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_ORDER_CATEGORY
 * PARTNER_ORDER_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_BUSINESS_AREA
 * PARTNER_BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_BUSINESS_AREA_NAME
 * PARTNER_BUSINESS_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_FUNCTIONAL_AREA
 * PARTNER_FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_FUNCTIONAL_AREA_NAME
 * PARTNER_FUNCTIONAL_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PROJECT_EXTERNAL_ID
 * PROJECT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#ORIGIN_COST_CENTER
 * ORIGIN_COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#FREE_DEFINED_CURRENCY5
 * FREE_DEFINED_CURRENCY5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#COMPANY_CODE_CURRENCY
 * COMPANY_CODE_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#ORIGIN_OBJECT_TYPE
 * ORIGIN_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#CONTROLLING_OBJECT_DEBIT_TYPE
 * CONTROLLING_OBJECT_DEBIT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_WBS_ELEMENT_INTERNAL_ID
 * PARTNER_WBS_ELEMENT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#GL_ACCOUNT_HIERARCHY
 * GL_ACCOUNT_HIERARCHY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#CUSTOMER_SERVICE_NOTIFICATION
 * CUSTOMER_SERVICE_NOTIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#FREE_DEFINED_CURRENCY7
 * FREE_DEFINED_CURRENCY7}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#ACCOUNT_ASSIGNMENT_NUMBER
 * ACCOUNT_ASSIGNMENT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#SALES_ORGANIZATION
 * SALES_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#TRANSACTION_TYPE_DETERMINATION
 * TRANSACTION_TYPE_DETERMINATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_PROJECT_NETWORK
 * PARTNER_PROJECT_NETWORK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_COMPANY_CODE
 * PARTNER_COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#SALES_ORDER_ITEM
 * SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#OFFSETTING_ACCOUNT_TYPE
 * OFFSETTING_ACCOUNT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#CALENDAR_YEAR_WEEK
 * CALENDAR_YEAR_WEEK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#SENDER_ACCOUNT_ASSIGNMENT_TYPE
 * SENDER_ACCOUNT_ASSIGNMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PURCHASING_DOCUMENT_ITEM
 * PURCHASING_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#SENDER_GL_ACCOUNT
 * SENDER_GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#PARTNER_SALES_DOCUMENT_ITEM
 * PARTNER_SALES_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#INVENTORY_VALUATION_TYPE
 * INVENTORY_VALUATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#SETTLEMENT_REFERENCE_DATE
 * SETTLEMENT_REFERENCE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#SETTLEMENT_REFERENCE_DATE_T
 * SETTLEMENT_REFERENCE_DATE_T}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupResult#DISTRIBUTION_CHANNEL
 * DISTRIBUTION_CHANNEL}</li>
 * </ul>
 *
 */
public interface MaterialGroupResultSelectable extends EntitySelectable<MaterialGroupResult>
{

}
