/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ODataQueryAdditionalMetadata;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ODataQueryAdditionalMetadata
 * ODataQueryAdditionalMetadata}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.ODataQueryAdditionalMetadataField
 * ODataQueryAdditionalMetadataField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.ODataQueryAdditionalMetadataLink
 * ODataQueryAdditionalMetadataLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ODataQueryAdditionalMetadata#O_DATA_QUERY_METADATA
 * O_DATA_QUERY_METADATA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ODataQueryAdditionalMetadata#O_DATA_QUERY_METADATA_VALUE_CURRENT
 * O_DATA_QUERY_METADATA_VALUE_CURRENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ODataQueryAdditionalMetadata#O_DATA_QUERY_METADATA_VALUE_AT_DEFINE
 * O_DATA_QUERY_METADATA_VALUE_AT_DEFINE}</li>
 * </ul>
 *
 */
public interface ODataQueryAdditionalMetadataSelectable extends EntitySelectable<ODataQueryAdditionalMetadata>
{

}
