/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccount;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccount OffsettingAccount}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.OffsettingAccountField
 * OffsettingAccountField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.OffsettingAccountLink
 * OffsettingAccountLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccount#OFFSETTING_ACCOUNT_ID
 * OFFSETTING_ACCOUNT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccount#OFFSETTING_ACCOUNT_TEXT
 * OFFSETTING_ACCOUNT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccount#OFFSETTING_ACCOUNT_TYPE
 * OFFSETTING_ACCOUNT_TYPE}</li>
 * </ul>
 *
 */
public interface OffsettingAccountSelectable extends EntitySelectable<OffsettingAccount>
{

}
