/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccount_2;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccount_2 OffsettingAccount_2}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.OffsettingAccount_2Field
 * OffsettingAccount_2Field} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.OffsettingAccount_2Link
 * OffsettingAccount_2Link}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccount_2#OFFSETTING_ACCOUNT_TYPE_ID
 * OFFSETTING_ACCOUNT_TYPE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccount_2#OFFSETTING_ACCOUNT_TYPE_TEXT
 * OFFSETTING_ACCOUNT_TYPE_TEXT}</li>
 * </ul>
 *
 */
public interface OffsettingAccount_2Selectable extends EntitySelectable<OffsettingAccount_2>
{

}
