/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginCostCtrActivity;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginCostCtrActivity OriginCostCtrActivity}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.OriginCostCtrActivityField
 * OriginCostCtrActivityField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.OriginCostCtrActivityLink
 * OriginCostCtrActivityLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginCostCtrActivity#ORIGIN_COST_CTR_ACTIVITY_TYPE_ID
 * ORIGIN_COST_CTR_ACTIVITY_TYPE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginCostCtrActivity#ORIGIN_COST_CTR_ACTIVITY_TYPE_TEXT
 * ORIGIN_COST_CTR_ACTIVITY_TYPE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginCostCtrActivity#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginCostCtrActivity#CONTROLLING_AREA_NAME
 * CONTROLLING_AREA_NAME}</li>
 * </ul>
 *
 */
public interface OriginCostCtrActivitySelectable extends EntitySelectable<OriginCostCtrActivity>
{

}
