/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBudgetPeriod;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBudgetPeriod PartnerBudgetPeriod}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerBudgetPeriodField
 * PartnerBudgetPeriodField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.PartnerBudgetPeriodLink
 * PartnerBudgetPeriodLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBudgetPeriod#PARTNER_BUDGET_PERIOD
 * PARTNER_BUDGET_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBudgetPeriod#PARTNER_BUDGET_PERIOD_TEXT
 * PARTNER_BUDGET_PERIOD_TEXT}</li>
 * </ul>
 *
 */
public interface PartnerBudgetPeriodSelectable extends EntitySelectable<PartnerBudgetPeriod>
{

}
