/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessArea;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessArea PartnerBusinessArea}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerBusinessAreaField
 * PartnerBusinessAreaField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.PartnerBusinessAreaLink
 * PartnerBusinessAreaLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessArea#PARTNER_BUSINESS_AREA_ID
 * PARTNER_BUSINESS_AREA_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessArea#PARTNER_BUSINESS_AREA_TEXT
 * PARTNER_BUSINESS_AREA_TEXT}</li>
 * </ul>
 *
 */
public interface PartnerBusinessAreaSelectable extends EntitySelectable<PartnerBusinessArea>
{

}
