/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessProcess;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessProcess
 * PartnerBusinessProcess}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerBusinessProcessField
 * PartnerBusinessProcessField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.PartnerBusinessProcessLink
 * PartnerBusinessProcessLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessProcess#PARTNER_BUSINESS_PROCESS
 * PARTNER_BUSINESS_PROCESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessProcess#PARTNER_BUSINESS_PROCESS_TEXT
 * PARTNER_BUSINESS_PROCESS_TEXT}</li>
 * </ul>
 *
 */
public interface PartnerBusinessProcessSelectable extends EntitySelectable<PartnerBusinessProcess>
{

}
