/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCompanyCode;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCompanyCode PartnerCompanyCode}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerCompanyCodeField
 * PartnerCompanyCodeField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.PartnerCompanyCodeLink
 * PartnerCompanyCodeLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCompanyCode#PARTNER_COMPANY_CODE_ID
 * PARTNER_COMPANY_CODE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCompanyCode#PARTNER_COMPANY_CODE_TEXT
 * PARTNER_COMPANY_CODE_TEXT}</li>
 * </ul>
 *
 */
public interface PartnerCompanyCodeSelectable extends EntitySelectable<PartnerCompanyCode>
{

}
