/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerControllingObjectClass;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerControllingObjectClass
 * PartnerControllingObjectClass}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerControllingObjectClassField
 * PartnerControllingObjectClassField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.PartnerControllingObjectClassLink
 * PartnerControllingObjectClassLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerControllingObjectClass#PARTNER_CONTROLLING_OBJECT_CLASS_ID
 * PARTNER_CONTROLLING_OBJECT_CLASS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerControllingObjectClass#PARTNER_CONTROLLING_OBJECT_CLASS_TEXT
 * PARTNER_CONTROLLING_OBJECT_CLASS_TEXT}</li>
 * </ul>
 *
 */
public interface PartnerControllingObjectClassSelectable extends EntitySelectable<PartnerControllingObjectClass>
{

}
