/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerFunctionalArea;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerFunctionalArea PartnerFunctionalArea}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerFunctionalAreaField
 * PartnerFunctionalAreaField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.PartnerFunctionalAreaLink
 * PartnerFunctionalAreaLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerFunctionalArea#PARTNER_FUNCTIONAL_AREA_ID
 * PARTNER_FUNCTIONAL_AREA_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerFunctionalArea#PARTNER_FUNCTIONAL_AREA_TEXT
 * PARTNER_FUNCTIONAL_AREA_TEXT}</li>
 * </ul>
 *
 */
public interface PartnerFunctionalAreaSelectable extends EntitySelectable<PartnerFunctionalArea>
{

}
