/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerOrderCategory;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerOrderCategory PartnerOrderCategory}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerOrderCategoryField
 * PartnerOrderCategoryField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.PartnerOrderCategoryLink
 * PartnerOrderCategoryLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerOrderCategory#PARTNER_ORDER_CATEGORY_ID
 * PARTNER_ORDER_CATEGORY_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerOrderCategory#PARTNER_ORDER_CATEGORY_TEXT
 * PARTNER_ORDER_CATEGORY_TEXT}</li>
 * </ul>
 *
 */
public interface PartnerOrderCategorySelectable extends EntitySelectable<PartnerOrderCategory>
{

}
