/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerOrder;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerOrder PartnerOrder}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerOrderField
 * PartnerOrderField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.PartnerOrderLink
 * PartnerOrderLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerOrder#PARTNER_ORDER
 * PARTNER_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerOrder#PARTNER_ORDER_TEXT
 * PARTNER_ORDER_TEXT}</li>
 * </ul>
 *
 */
public interface PartnerOrderSelectable extends EntitySelectable<PartnerOrder>
{

}
