/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProjectInternalID;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProjectInternalID
 * PartnerProjectInternalID}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerProjectInternalIDField
 * PartnerProjectInternalIDField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.PartnerProjectInternalIDLink
 * PartnerProjectInternalIDLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProjectInternalID#PARTNER_PROJECT_INTERNAL_IDID
 * PARTNER_PROJECT_INTERNAL_IDID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProjectInternalID#PARTNER_PROJECT_EXTERNAL_ID
 * PARTNER_PROJECT_EXTERNAL_ID}</li>
 * </ul>
 *
 */
public interface PartnerProjectInternalIDSelectable extends EntitySelectable<PartnerProjectInternalID>
{

}
