/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocumentItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocumentItem
 * PartnerSalesDocumentItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerSalesDocumentItemField
 * PartnerSalesDocumentItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.PartnerSalesDocumentItemLink
 * PartnerSalesDocumentItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocumentItem#PARTNER_SALES_DOCUMENT_ITEM_ID
 * PARTNER_SALES_DOCUMENT_ITEM_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocumentItem#PARTNER_SALES_DOCUMENT_ITEM_TEXT
 * PARTNER_SALES_DOCUMENT_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocumentItem#PARTNER_SALES_DOCUMENT
 * PARTNER_SALES_DOCUMENT}</li>
 * </ul>
 *
 */
public interface PartnerSalesDocumentItemSelectable extends EntitySelectable<PartnerSalesDocumentItem>
{

}
