/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocument;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocument PartnerSalesDocument}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerSalesDocumentField
 * PartnerSalesDocumentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.PartnerSalesDocumentLink
 * PartnerSalesDocumentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocument#PARTNER_SALES_DOCUMENT
 * PARTNER_SALES_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocument#PARTNER_SALES_DOCUMENT_TEXT
 * PARTNER_SALES_DOCUMENT_TEXT}</li>
 * </ul>
 *
 */
public interface PartnerSalesDocumentSelectable extends EntitySelectable<PartnerSalesDocument>
{

}
