/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSegment;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSegment PartnerSegment}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerSegmentField
 * PartnerSegmentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.PartnerSegmentLink PartnerSegmentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSegment#PARTNER_SEGMENT_ID
 * PARTNER_SEGMENT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSegment#PARTNER_SEGMENT_TEXT
 * PARTNER_SEGMENT_TEXT}</li>
 * </ul>
 *
 */
public interface PartnerSegmentSelectable extends EntitySelectable<PartnerSegment>
{

}
