/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerWBSElementInternalID;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerWBSElementInternalID
 * PartnerWBSElementInternalID}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerWBSElementInternalIDField
 * PartnerWBSElementInternalIDField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.PartnerWBSElementInternalIDLink
 * PartnerWBSElementInternalIDLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerWBSElementInternalID#PARTNER_WBS_ELEMENT_INTERNAL_IDID
 * PARTNER_WBS_ELEMENT_INTERNAL_IDID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerWBSElementInternalID#PARTNER_WBS_ELEMENT_EXTERNAL_ID
 * PARTNER_WBS_ELEMENT_EXTERNAL_ID}</li>
 * </ul>
 *
 */
public interface PartnerWBSElementInternalIDSelectable extends EntitySelectable<PartnerWBSElementInternalID>
{

}
